<?php
/**
 * Plugin Name: Octocom
 * Description: Adds the Octocom Chatbot script to WordPress.
 * Version: 1.0.3
 * Author: Octocom
 * Author URI: https://www.octocom.ai
 * Developer: Octocom
 * Developer URI: https://www.octocom.ai

 * WC requires at least: 8.0
 * WC tested up to: 9.1

 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function octocom_activate() {
    octocom_send_data('plugin_activated');
}

function octocom_deactivate() {
    octocom_send_data('plugin_deactivated');
}

function octocom_update($upgrader_object, $options) {
    if ($options['action'] == 'update' && $options['type'] == 'plugin') {
        if (isset($options['plugins']) && is_array($options['plugins'])) {
            foreach ($options['plugins'] as $plugin) {
                if (basename($plugin) == basename(__FILE__)) {
                    octocom_send_data('plugin_updated');
                    break;
                }
            }
        }
    }
}

register_activation_hook(__FILE__, 'octocom_activate');
register_deactivation_hook(__FILE__, 'octocom_deactivate');
add_action('upgrader_process_complete', 'octocom_update', 10, 2);


function octocom_send_data($action) {
    $site_url = get_site_url();
    
    $admin_users = get_users(array('role' => 'administrator'));
    $admin_emails = array();
    
    foreach ($admin_users as $user) {
        if (!empty($user->user_email) && is_email($user->user_email)) {
            $admin_emails[] = $user->user_email;
        }
    }
    
    $data = array(
        'site_url' => $site_url,
        'admin_emails' => $admin_emails,
        'plugin_version' => '1.0.3', // Match plugin version
        'action' => $action,
    );
    
    $response = wp_remote_post('https://api.octocom.ai/woocommerce/plugin-installed', array(
        'method' => 'POST',
        'timeout' => 30,
        'redirection' => 5,
        'httpversion' => '1.1',
        'blocking' => false,
        'headers' => array(
            'Content-Type' => 'application/json',
        ),
        'body' => json_encode($data),
        'cookies' => array()
    ));
}

function octocom_enqueue_script() {
    echo '<script async src="https://www.octocom.ai/chatbot/bundle.js"></script>';
}

add_action('wp_head', 'octocom_enqueue_script');

// Declare HPOS compatibility
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

// Add settings page
function octocom_add_admin_menu() {
    global $submenu;
    
    // Check if main Octocom menu already exists
    $octocom_menu_exists = false;
    if (isset($submenu['octocom'])) {
        $octocom_menu_exists = true;
    }
    
    // If main Octocom menu doesn't exist, create it
    if (!$octocom_menu_exists) {
        // Create the main Octocom menu
        add_menu_page(
            'Octocom',
            'Octocom',
            'manage_options',
            'octocom',
            null, // No callback since we'll use submenu pages
            'none',
            100
        );
    }
    
    // Add AI Chatbot as a submenu
    add_submenu_page(
        'octocom',
        'AI Chatbot',
        'AI Chatbot',
        'manage_options',
        'octocom',
        'octocom_settings_page'
    );
}
add_action('admin_menu', 'octocom_add_admin_menu');

// Add custom SVG icon
function octocom_admin_menu_style() {
    echo '<style>
        #toplevel_page_octocom .wp-menu-image::before {
            content: "";
            background-image: url("data:image/svg+xml;base64,' . base64_encode('<svg width="20" height="20" viewBox="0 0 1200 1200" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="1200" height="1200" rx="150" fill="#232426"/>
<path d="M600 1050C848.528 1050 1050 848.528 1050 600C1050 351.472 848.528 150 600 150C351.472 150 150 351.472 150 600C150 848.528 351.472 1050 600 1050Z" stroke="#3B82F6" stroke-width="85"/>
</svg>') . '");
            background-repeat: no-repeat;
            background-position: center;
            background-size: 20px 20px;
            display: block;
            width: 20px;
            height: 20px;
            margin-left: 7px;
        }
        .admin-color-fresh #toplevel_page_octocom.current .wp-menu-image::before, 
        .admin-color-fresh #toplevel_page_octocom:hover .wp-menu-image::before {
            background-image: url("data:image/svg+xml;base64,' . base64_encode('<svg width="20" height="20" viewBox="0 0 1200 1200" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="1200" height="1200" rx="150" fill="#232426"/>
<path d="M600 1050C848.528 1050 1050 848.528 1050 600C1050 351.472 848.528 150 600 150C351.472 150 150 351.472 150 600C150 848.528 351.472 1050 600 1050Z" stroke="#ffffff" stroke-width="85"/>
</svg>') . '");
        }
    </style>';
}
add_action('admin_head', 'octocom_admin_menu_style');

// Settings page content
function octocom_settings_page() {
    // Send data when settings page is visited
    octocom_send_data('settings_page_visited');
    
    // SVG logo for inline use
    $octocom_logo = '<svg width="40" height="40" viewBox="0 0 1200 1200" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect width="1200" height="1200" rx="150" fill="#232426"/>
    <path d="M600 1050C848.528 1050 1050 848.528 1050 600C1050 351.472 848.528 150 600 150C351.472 150 150 351.472 150 600C150 848.528 351.472 1050 600 1050Z" stroke="#3B82F6" stroke-width="85"/>
    </svg>';
    ?>

    <?php
    $data = array(
        'site_url' => get_site_url(),
    );
    ?>

    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <div class="card" style="padding: 20px;">
            <div style="margin-bottom: 15px;">
                <?php echo $octocom_logo; ?>
            </div>
            <h2>Welcome to Octocom</h2>
            <p>Manage your chatbot and settings from the Octocom Dashboard.</p>
            <p><a href="https://api.octocom.ai/dashboard-redirect?source=woocommerce&info=<?php echo urlencode(json_encode($data)); ?>" class="button button-primary" target="_blank">Open Octocom Dashboard</a></p>
        </div>
    </div>
    <?php
}
